C                           TROPHIC IMPACT ANALYSIS
C                           COPYRIGHT 1988 BY
C                             R. E. ULANOWICZ
C 
C   THIS ANALYSIS PACKAGE IS A HYBRID OF STANDARD INPUT-OUTPUT ANALYSIS
C   AND LEVIN'S QUALITATIVE LOOP-ANALYSIS. EACH TROPHIC TRANSFER IS ASSUMED
C   TO HAVE A POSITIVE INFLUENCE UPON THE PREDATOR (OR PASSIVE RECEPTOR)
C   A NEGATIVE INFLUENCE UPON THE PREY (OR DONOR). THE MAGNITUDES OF THE
C   POSITIVE INFLUENCES ARE TAKEN TO BE IDENTICAL TO THE LEONTIEF TECHNICAL
C   COEFFICIENTS, WHEREAS THE NEGATIVE INFLUENCES ARE GUAGED BY THE
C   AUGUSTINOVICS INDICIES AS MODIFIED TO EXCLUDE RESPIRATIONS.
C   FOR FULL DOCUMENTATION SEE THE FILE IMPACTS.DOC.
C 
C  M IS 3 GREATER THAN THE MAXIMUM NUMBER OF COMPARTMENTS TO BE TREATED.
C  (37 IN THIS INSTANCE) IF MORE STORAGE IS REQUIRED, CHANGE THE NEXT
C  PARAMETER STATEMENT AND THE CORRESPONDING ONE IN SUBROUTINE LOOPS.
      PARAMETER (M=140)
      DIMENSION A(M,M), AINPUT(M), BINPUT(M), EXPORT(M), FEED(M,M),
     1HOST(M,M), NS(M), NS2(M), RESP(M), TL(M,7), U(M), V(M), 
     2XCHNGE(M,M)
C 
C    READ IN THE DATA.
C    STANDARD SCOR INPUT FORMAT IS USED.
      MQ=M
C 
C             READ IN THE TITLE BANNER.
C 
  100 READ (7,110,END=770,ERR=890) (TL(1,J),J=1,7),(TL(2,J),J=1,7),(TL(3
     1,J),J=1,6),NX
  110 FORMAT (19A4,A2,I2)
C             IF A STEADY-STATE NETWORK IS EXPECTED IN ADVANCE, READ IN
C             NX=-LOG(LEAST SIGNIFICANT DIGIT),E.G.,IF SMALLEST FLOW
C             IN THE NETWORK IS .002, THEN PUT A 3 IN COLUMN 80.
      EPS=1.0E-06
      IF (NX.NE.0) EPS=10.**(1-NX)
      WRITE (8,120) (TL(1,J),J=1,7),(TL(2,J),J=1,7),(TL(3,J),J=1,6)
  120 FORMAT (1X,19A4,A2,/)
C             N IS THE NUMBER OF COMPARTMENTS IN THIS RUN.
C             NL IS THE NUMBER OF LIVING, FEEDING COMPARTMENTS. ALL LIVI
C             COMPARTMENTS SHOULD APPEAR FIRST IN THE LIST OF SPECIES, A
C             ALL NON-LIVING SPECIES SHOULD BE GROUPED AT THE END OF THE
      READ (7,130,END=770,ERR=910) N,NL
  130 FORMAT (2I3)
      NLP1=NL+1
      WRITE (8,140) N
  140 FORMAT (1X,'NUMBER OF COMPARTMENTS IS ',I4)
      IF (N.GT.M) GO TO 910
C             IF NO INPUT IS PROVIDED TO NL, ALL COMPARTMENTS ARE ASSUME
      IF (NL.LE.0) NL=N
      IF (NL.GE.N) GO TO 160
      WRITE (8,150) NL
  150 FORMAT (1X,'NUMBER OF LIVING COMPARTMENTS IS',I4)
C             READ IN THE NAME OF EACH COMPARTMENT.
  160 WRITE (8,170)
  170 FORMAT (/,1X,'LIVING COMPARTMENTS',/)
      DO 190 I=1,NL
          READ (7,180) (TL(I,J),J=1,7)
  180     FORMAT (6A4,A1)
  190     WRITE (8,200) I,(TL(I,J),J=1,7)
  200 FORMAT (1X,I3,2X,6A4,A1)
      IF (NL.GE.N) GO TO 230
      WRITE (8,210)
  210 FORMAT (/,1X,'NON-LIVING COMPARTMENTS',/)
      DO 220 I=NLP1,N
          READ (7,180) (TL(I,J),J=1,7)
  220     WRITE (8,200) I,(TL(I,J),J=1,7)
C 
C             INITIALIZE INPUT ARRAYS.
C 
  230 NP1=N+1
      DO 240 I=1,N
          AINPUT(I)=0.
          EXPORT(I)=0.
          RESP(I)=0.
          DO 240 J=1,N
  240     XCHNGE(I,J)=0.
C 
C             READ PAST THE BIOMASSES. THEY ARE NOT USED IN THIS PACKAGE
C 
      DO 260 I=1,NP1
          READ (7,250) ICOL,VALUE
  250     FORMAT (I3,E14.7)
          IF (ICOL.LE.0) GO TO 270
  260 CONTINUE
C             AINPUT STORES THE INPUTS FROM OUTSIDE THE SYSTEM.
  270 DO 280 I=1,NP1
          READ (7,250) ICOL,VALUE
          IF (ICOL.LE.0) GO TO 290
          AINPUT(ICOL)=VALUE
  280 CONTINUE
  290 WRITE (8,300)
  300 FORMAT (/,1X,'INPUT VECTOR')
      CALL VECPRT (AINPUT,N,M)
      DO 310 I=1,N
  310     IF (AINPUT(I).LT.0.) GO TO 930
C             EXPORT STORES NON-RESPIRATIONAL LOSSES FROM THE SYSTEM.
      DO 320 I=1,NP1
          READ (7,250) ICOL,VALUE
          IF (ICOL.LE.0) GO TO 330
          EXPORT(ICOL)=VALUE
  320 CONTINUE
  330 WRITE (8,340)
  340 FORMAT (1X,'EXPORT VECTOR')
      CALL VECPRT (EXPORT,N,M)
      DO 350 I=1,N
  350     IF (EXPORT(I).LT.0.) GO TO 950
C             RESP STORES THE MEASURED RESPIRATIONS.
      DO 360 I=1,NP1
          READ (7,250) ICOL,VALUE
          IF (ICOL.LE.0) GO TO 370
          RESP(ICOL)=VALUE
  360 CONTINUE
  370 DO 380 I=1,N
  380     IF (RESP(I).LT.0.) GO TO 990
      WRITE (8,390)
  390 FORMAT (1X,'RESPIRATION VECTOR')
      CALL VECPRT (RESP,N,M)
C             XCHNGE IS THE MATRIX OF INTERNAL EXCHANGES AMONG THE
C             COMPARTMENTS. ALL ENTRIES ARE POSITIVE OR ZERO. A
C             POSITIVE ENTRY IN ROW I AND COLUMN J DESIGNATES A
C             TRANSFER FROM COMPARTMENT I TO COMPARTMENT J.
      DO 410 I=1,NP1
          DO 410 J=1,NP1
          READ (7,400) IROW,ICOL,VALUE
  400     FORMAT (I3,I3,E14.7)
          IF (IROW.LE.0) GO TO 420
          XCHNGE(IROW,ICOL)=VALUE
  410 CONTINUE
  420 WRITE (8,430)
  430 FORMAT (1X,'EXCHANGE MATRIX')
      CALL MATPRT (XCHNGE,N,M)
      DO 440 I=1,N
          DO 440 J=1,N
  440     IF (XCHNGE(I,J).LT.0.) GO TO 970
C 
C             CALCULATE THE INPUT AND OUTPUT THROUGHPUTS AS WELL AS
C             THE DIFFERENCES BETWEEN THEM.
C 
      DSUM=0.
      DO 460 I=1,N
          BINPUT(I)=AINPUT(I)
          U(I)=EXPORT(I)+RESP(I)
          DO 450 J=1,N
              BINPUT(I)=BINPUT(I)+XCHNGE(J,I)
  450         U(I)=U(I)+XCHNGE(I,J)
          V(I)=BINPUT(I)-U(I)
          IF (ABS(V(I)).LT.EPS) V(I)=0.
          DSUM=DSUM+ABS(V(I))
  460 CONTINUE
      IF (DSUM.LE.0.) GO TO 520
      WRITE (8,470)
  470 FORMAT (/,1X,'WARNING! - NETWORK IS NON STEADY-STATE!',/)
      WRITE (8,480)
  480 FORMAT (1X,'COMPARISON OF THROUGHPUTS')
      WRITE (8,490)
  490 FORMAT (/,6X,'INPUTS',6X,'OUTPUTS',4X,'IMBALANCE',/)
      DO 500 I=1,N
  500     WRITE (8,510) I,BINPUT(I),U(I),V(I)
  510 FORMAT (2X,I3,2X,E8.3,4X,E8.3,4X,E9.3)
      GO TO 540
  520 WRITE (8,530)
  530 FORMAT (1X,'COMPARTMENTAL THROUGHPUTS')
      CALL VECPRT (BINPUT,N,M)
  540 DO 550 I=1,N
  550     IF ((0.5*(BINPUT(I)+U(I))).LE.0.) GO TO 1010
C 
C             CALCULATE THE FEEDING AND HOST COEFFICIENTS.
C 
      DO 580 I=1,N
          V(I)=AMAX1(BINPUT(I),U(I))
          DO 560 J=1,N
              HOST(I,J)=0.
  560         FEED(J,I)=XCHNGE(J,I)/V(I)
          IF ((V(I)-RESP(I)).LE.0.) GO TO 580
C    DEAD COMPARTMENTS DON'T EXERT PREDATOR IMPACTS UPON LIVING SPECIES.
          DO 570 J=1,NL
  570         HOST(I,J)=XCHNGE(I,J)/(V(I)-RESP(I))
  580 CONTINUE
C 
C             ASSEMBLE THE MATRIX OF DIRECT TROPHIC IMPACTS.
C 
      DO 590 I=1,N
          DO 590 J=1,N
  590     A(I,J)=FEED(I,J)-HOST(J,I)
      WRITE (8,600)
  600 FORMAT (/,1X,'MATRIX OF DIRECT TROPHIC INTERACTIONS',/)
      CALL MATPRT (A,N,M)
      DO 610 I=1,N
          A(I,I)=1.-A(I,I)
          DO 610 J=1,N
          IF (I.EQ.J) GO TO 610
          A(I,J)=-A(I,J)
  610 CONTINUE
      CALL INV (A,A,V,N,M)
      DO 620 I=1,N
  620     A(I,I)=A(I,I)-1.
      WRITE (8,630)
  630 FORMAT (1X,'MATRIX OF TOTAL TROPHIC IMPACTS.',/)
      CALL MATPRT (A,N,M)
C 
C             SEARCH FOR "BENEFICIAL PREDATORS, I.E., THOSE WHOSE DIRECT
C             IMPACTS ARE NEGATIVE, BUT WHOSE TOTAL TROPHIC EFFECT IS
C             POSITIVE.
C 
      NBEN=0
      WRITE (8,640)
  640 FORMAT (/,1X,'SEARCH FOR "BENEFICIAL" PREDATORS.',//,1X,12X,'PREDA
     1TOR',28X,'PREY',14X,'EFFECT',/)
      DO 670 I=1,NL
          DO 670 J=1,NL
          IF (((FEED(I,J)-HOST(J,I)).LT.0.).AND.(A(I,J).GT.0.)) GO TO
     1     650
          GO TO 670
  650     NBEN=NBEN+1
          WRITE (8,660) I,(TL(I,K),K=1,5),J,(TL(J,K),K=1,5),A(I,J)
  660     FORMAT (1X,I3,1X,5A4,2X,' BENEFITS ',1X,I3,1X,5A4,2X,E10.4)
  670 CONTINUE
      IF (NBEN.LE.0) WRITE (8,680)
  680 FORMAT (1X,'(NO BENEFICIAL PREDATORS FOUND.)',/)
C 
C        SEARCH FOR "MALEFIC PREY", I.E., THOSE WHOSE DIRECT
C        IMPACTS ARE POSITIVE, BUT WHOSE TOTAL TROPHIC EFFECT IS
C        NEGATIVE.
C 
      NBAD=0
      WRITE (8,690)
  690 FORMAT (/,1X,'SEARCH FOR "MALEFIC" PREY.',//,1X,14X,'PREY',32X,'PR
     1EDATOR',10X,'EFFECT',/)
      DO 720 I=1,NL
          DO 720 J=1,NL
          IF (((FEED(I,J)-HOST(J,I)).GT.0.).AND.(A(I,J).LT.0.)) GO TO
     1     700
          GO TO 720
  700     NBAD=NBAD+1
          WRITE (8,710)I,(TL(I,K),K=1,5),J,(TL(J,K),K=1,5),A(I,J)
  710     FORMAT(1X,I3,1X,5A4,2X,' DECREMENTS ',1X,I3,1X,5A4,2X,E10.4)
  720 CONTINUE
      IF (NBAD.LE.0) WRITE (8,730)
  730 FORMAT (1X,'(NO MALEFIC PREY FOUND.)',/)
C 
C             EXAMINE IMPACTS ON A PARTICULAR SPECIES IN ORDER.
C 
  740 WRITE (*,750)
  750 FORMAT (//,1X,'SPECIFY FOCAL COMPARTMENT (END=-1).',/)
      READ (*,*) NF
      IF (NF.LE.0) GO TO 100
      IF (NF.LE.N) GO TO 780
      WRITE (*,760) N
  760 FORMAT (1X,'FOCAL COMPARTMENT MUST BE < OR = ',I3,/)
      GO TO 740
  770 STOP
  780 DO 790 I=1,N
          NS(I)=I
  790     V(I)=A(I,NF)
C 
C             ORDER THE IMPACTS UPON FOCAL SPECIES BY THEIR MAGNITUDES.
C 
      NM1=N-1
      DO 810 I=1,NM1
          BIG=-1000.
          DO 800 J=I,N
              IF (V(J).LE.BIG) GO TO 800
              BIG=V(J)
              IBIG=J
  800     CONTINUE
          ITEMP=NS(I)
          TEMP=V(I)
          NS(I)=NS(IBIG)
          V(I)=BIG
          NS(IBIG)=ITEMP
          V(IBIG)=TEMP
  810 CONTINUE
C 
C             ORDER THE EFFECTS OF FOCAL SPECIES.
C 
      WRITE (8,820) NF
  820 FORMAT (//,1X,'IMPACTS PERTAINING TO ',I3,/)
      WRITE (8,830) NF,NF
  830 FORMAT (1X,'RANK',3X,'IMPACTS UPON ',I3,3X,'EFFECTS FROM ',I3)
      DO 840 I=1,N
          NS2(I)=I
  840     U(I)=A(NF,I)
      NM1=N-1
      DO 860 I=1,NM1
          BIG=-1000.
          DO 850 J=I,N
              IF (U(J).LE.BIG) GO TO 850
              BIG=U(J)
              IBIG=J
  850     CONTINUE
          ITEMP=NS2(I)
          TEMP=U(I)
          NS2(I)=NS2(IBIG)
          U(I)=BIG
          NS2(IBIG)=ITEMP
          U(IBIG)=TEMP
  860 CONTINUE
      DO 870 I=1,N
  870     WRITE (8,880) I,NS(I),V(I),NS2(I),U(I)
  880 FORMAT (2X,I3,5X,I3,1X,E9.3,6X,I3,1X,E9.3)
      CALL LOOPS (A,NS2,NF,N,M)
      GO TO 740
C 
C             ERROR DIAGNOSTICS FOLLOW:
C 
  890 WRITE (8,900)
  900 FORMAT ('0 ERROR IN TITLE')
      STOP
  910 WRITE (8,920) MQ
  920 FORMAT ('0 ERROR NUMBER OF COMPARTMENTS MAX=',I3)
      STOP
  930 WRITE (8,940)
  940 FORMAT ('0 ERROR INPUT VECTOR CANNOT BE LESS THAN 0')
      STOP
  950 WRITE (8,960)
  960 FORMAT ('0 ERROR EXPORT VECTOR CAN NOT HAVE VALUES LESS THAN 0')
      STOP
  970 WRITE (8,980)
  980 FORMAT ('0 ERROR EXCHANGE MATRIX CAN NOT HAVE VALUES LESS THAN 0')
      STOP
  990 WRITE (8,1000)
 1000 FORMAT ('0 ERROR RESPIRATIONS CANNOT BE LESS THAN 0.')
      STOP
 1010 WRITE (8,1020)
 1020 FORMAT ('0 ERROR COMPARTMENTAL THROUGHPUTS MUST BE GREATER THAN 0'
     1)
      STOP
      END
C  THE OBJECTIVE OF THIS ALGORITHM IS TO LOCATE ALL THE AUTO-
C  CATALYTIC LOOPS IN WHICH A GIVEN SPECIES PARTICIPATES. IT
C  WORKS FROM THE MATRIX OF TOTAL IMPACTS, WHICH CONTAINS BOTH
C  POSITIVE AND NEGATIVE CUMULATIVE IMPACTS. THE ORDER IN WHICH
C  THE NODES ARE TO BE CONSIDERED IN THE BACKTRACKING
C  WAS DETERMINED IN THE CALLING ROUTINE.
C 
      SUBROUTINE LOOPS (WEB,MAP,NFOC,N,MM)
C 
C  WEB IS THE MATRIX OF TOTAL TROPHIC IMPACTS WITHIN THE
C    N-COMPARTMENT SYSTEM.
C  MAP IS A VECTOR CONTAINING THE ORDER IN WHICH THE FOCAL ELEMENT
C    AFFECTS OTHER ELEMENTS IN THE SYSTEM.
C  NFOC IS THE LOCATION OF THE FOCAL ELEMENT.
C  N IS THE NUMBER OF COMPARTMENTS IN THE PRESENT RUN.
C  MM IS THE MAXIMUM DIMENSION OF THE PROBLEM AS SPECIFIED IN AMAIN.
C 
      PARAMETER (MX=140)
      PARAMETER (NPATHS=1000)
      PARAMETER (NWORD=4)
      PARAMETER (MPATH=(((MX/2+1)/NWORD)+1)*NPATHS)
C    MX IS EQUAL TO MM, BUT MUST BE DEFINED LOCALLY.
C    NPATHS IS THE EXPECTED NUMBER OF SIMPLE CYCLES.
C    NWORD IS 1/2 THE NUMBER OF DECIMAL DIGITS WHICH CAN BE STORED
C      IN A SINGLE INTEGER WORD. THIS IS MACHINE-DEPENDENT.
C    MPATH IS THE ESTIMATED NUMBER OF LOCATIONS NECESSARY TO STORE
C      ALL THE SIMPLE CYCLES.
C 
      DIMENSION GAIN(NPATHS), KEEPTH(MPATH), LENGTH(NPATHS), MAP(MM),
     1NODE(MX), NTEMP(MX), WEB(MM,MM)
      EQUIVALENCE (NODE(1),NTEMP(1))
C   GAIN STORES THE AUTOCATALYTIC GAIN OF EACH CYCLE.
C   KEEPTH STORES THE COMPLETED CYCLES.
C   KPTH IS THE RUNNING TALLY OF SIMPLE CYCLES
C   LENGTH STORES THE LENGTHS OF EACH CYCLE IN KEEPTH.
C   MAP STORES THE ORDER IN WHICH THE NODES ARE CONSIDERED.
C   NODE STORES THE PARTIAL PATHWAY BEING BUILT.
C   WEB IS THE MATRIX OF IMPACTS UNDER STUDY.
C 
      NWP=(N/NWORD)+1
C 
C             THE ORDER IN WHICH THE NODES ARE CONSIDERED (MAP) IS THE
C             DECENDING ORDER OF THE IMPACTS THAT THE FOCAL SPECIES HAS
C             THE OTHER MEMBERS OF THE NETWORK. THIS ORDER WAS DETERMINE
C             IN THE CALLING ROUTINE. ALL THAT REMAINS TO DO HERE IS TO
C             THE FOCAL INDEX AT THE HEAD OF THE LIST.
C 
      SQELCH=1.E-08
      WRITE (8,100) NFOC
  100 FORMAT (//,1X,'AUTOCATALYTIC LOOPS CONTAINING ',I3,/)
  110 NB4=NFOC
      DO 130 I=1,N
          IF (MAP(I).NE.NFOC) GO TO 120
          MAP(I)=NB4
          GO TO 140
  120     MTEMP=MAP(I)
          MAP(I)=NB4
          NB4=MTEMP
  130 CONTINUE
C    COUNT UP THE NUMBER OF POSITIVE EFFECTS BY FOCAL SPECIES.
C    NEGATIVE EFFECTS BY FOCAL NODE CAN BE DROPPED FROM CONSIDERATION.
  140 NSTP=1
      DO 150 I=2,N
  150     IF (WEB(NFOC,MAP(I)).GT.0.) NSTP=NSTP+1
      KPTH=0
      LMAX=0
C 
C             BEGIN BACKTRACK ALGORITHM.
C 
      NSTRT=1
C             INITIALIZE STARTING NODE AND LEVEL.
      LEVEL=1
      NODE(1)=NSTRT
C             ADVANCE TO NEXT LEVELS.
  160 LM1=LEVEL
      LEVEL=LEVEL+1
      NODE(LEVEL)=NSTRT
C             CHECK FOR CONNECTION BETWEEN NODES AT PRESENT TWO LEVELS.
  170 NZ1=NODE(LM1)
      KROW=MAP(NZ1)
      NZ2=NODE(LEVEL)
      KCOL=MAP(NZ2)
C    ONLY CONNECTIONS ABOVE A THRESHOLD VALUE, SQELCH, ARE CONSIDERED.
      IF (WEB(KROW,KCOL).GT.SQELCH) GO TO 200
C             TRY NEXT NODE IN NEXT LEVEL.
  180 NODE(LEVEL)=NODE(LEVEL)+1
      IF (NODE(LEVEL).GT.NSTP) GO TO 190
      GO TO 170
C             BACKTRACK TO PREVIOUS LEVEL.
  190 LEVEL=LEVEL-1
      LM1=LEVEL-1
C             IF FURTHER BACKTRACKING IS IMPOSSIBLE,END SEARCH UNDER
C             PRESENT NSTRT.
      IF (LEVEL.LE.1) GO TO 270
      GO TO 180
C             IF THIS CONNECTION COMPLETES CYCLE,STORE THE RESULTS.
  200 IF (NODE(LEVEL).EQ.NSTRT) GO TO 220
C 
C             CHECK TO SEE EITHER IF THIS NODE HAS APPEARED PREVIOUSLY I
C             PATHWAY OR IF A PREVIOUS NODE HAS A STRONGER NEGATIVE EFFE
C             THIS NODE. BOTH CONDITIONS DISQUALIFY A CONNECTION.
C 
      AMP=1.
      DO 210 K=LM1,1,-1
          IF (NODE(LEVEL).EQ.NODE(K)) GO TO 180
          AMP=AMP*WEB(MAP(NODE(K)),MAP(NODE(K+1)))
          TEMP=-WEB(MAP(NODE(K)),MAP(NODE(LEVEL)))
  210     IF (AMP.LT.TEMP) GO TO 180
      GO TO 160
  220 KPTH=KPTH+1
      IF ((NWP*KPTH).LE.MPATH) GO TO 250
C    IF THERE ARE TOO MANY PATHWAYS FOR THE ALLOCATED STORAGE, INCREASE
C    THE SEARCH THRESHOLD AND REDO THE SEARCH.
      NZ1=NODE(LM1)
      NZ2=NODE(LEVEL)
C    IF THRESHOLD GETS TOO HIGH, TERMINATE THE PROGRAM.
      IF (SQELCH.GT.10.) GO TO 230
      SQELCH=10.*SQELCH
      GO TO 110
  230 WRITE (*,240) MAP(NSTRT),LM1,MAP(NZ1),MAP(NZ2),KPTH,SQELCH
  240 FORMAT (//,3X,'LOOP STORAGE EXCEEDED',4I3,I6,2X,E9.3)
      STOP
  250 IF (LM1.GT.LMAX) LMAX=LM1
      DO 260 NQ=1,LEVEL
          NTP=NODE(NQ)
          NTP=MAP(NTP)
  260     CALL NCODE (KEEPTH,KPTH,NQ,NTP,NWP,NWORD)
      LENGTH(KPTH)=LM1
      GO TO 180
  270 IF (KPTH.GT.0) GO TO 290
      WRITE (8,280)
  280 FORMAT (1X,'(NO AUTOCATALYTIC LOOPS DETECTED.)',/)
      GO TO 380
C 
C             CALCULATE THE GAIN FACTOR FOR EACH LOOP.
C 
  290 DO 310 K=1,KPTH
          GAIN(K)=1.
          LTH=LENGTH(K)
          DO 300 KK=1,LTH
              KKP1=KK+1
              KB=NDCODE(KEEPTH,K,KK,NWP,NWORD)
              KE=NDCODE(KEEPTH,K,KKP1,NWP,NWORD)
  300         GAIN(K)=GAIN(K)*WEB(KB,KE)
  310 CONTINUE
C 
C             REPORT THE LOOPS IN DESCENDING ORDER OF THEIR GAINS.
C 
      WRITE (8,320)
  320 FORMAT (//,1X,'LOOP',3X,'GAIN',4X,'CYCLE DESCRIPTION',/)
      DO 360 K=1,KPTH
          GMAX=-1000.
          KMAX=1
          DO 330 KK=1,KPTH
              IF (GAIN(KK).LE.GMAX) GO TO 330
              KMAX=KK
              GMAX=GAIN(KK)
  330     CONTINUE
          LTH=LENGTH(KMAX)
          DO 340 KK=1,LTH
  340         NTEMP(KK)=NDCODE(KEEPTH,KMAX,KK,NWP,NWORD)
          WRITE (8,350) K,GAIN(KMAX),(NTEMP(KK),KK=1,LTH)
  350     FORMAT (1X,I3,'.',E9.3,2X,20(I3,'-'))
C             DELETE KMAX FROM FURTHER CONSIDERATION.
          GAIN(KMAX)=-1.E+06
  360 CONTINUE
      IF (SQELCH.GT.2.E-08) WRITE (8,370) SQELCH
  370 FORMAT (/,1X,'SQUELCH THRESHOLD = ',E9.3,/)
  380 RETURN
      END
C    A VERY PRIMITIVE ROUTINE TO INVERT A SQUARE MATRIX BY
C    A SEQUENCE OF ROW OPERATIONS. INVERSION IN PLACE IS
C    ALLOWED.
C 
      SUBROUTINE INV (P,A,B,N,M)
C 
C    P IS THE INVERSE UPON RETURN.
C    A IS THE INPUT MATRIX.
C    B IS AN N-DIMENSIONAL UTILITY ARRAY.
C    N IS THE DIMENSION OF THE INPUT AND OUTPUT MATRICES.
C    M IS THE MAXIMUM VALUE OF N AS DIMENSIONED IN THE CALLING
C    ROUTINE.
C 
      DIMENSION A(M,M), B(M), P(M,M)
      DO 100 I=1,N
          B(I)=0.0
          DO 100 J=1,N
          P(I,J)=A(I,J)
  100 CONTINUE
      DO 200 K=1,N
          B(K)=1.0
          IF (P(K,1)) 130,110,130
  110     WRITE (*,120) K
  120     FORMAT (//,' TROUBLE DURING MATRIX INVERSION AT ROW ',I3,//)
          GO TO 210
  130     DO 140 J=2,N
  140         P(K,J)=P(K,J)/P(K,1)
          B(K)=B(K)/P(K,1)
          DO 170 I=1,N
              IF (I-K) 150,170,150
  150         DO 160 J=2,N
  160             P(I,J)=P(I,J)-P(I,1)*P(K,J)
              B(I)=B(I)-P(I,1)*B(K)
  170     CONTINUE
          DO 190 I=1,N
              N1=N-1
              DO 180 J=1,N1
  180             P(I,J)=P(I,J+1)
              P(I,N)=B(I)
              B(I)=0.0
  190     CONTINUE
  200 CONTINUE
  210 RETURN
      END
C    A ROUTINE TO PRINT OUT SQUARE MATRICES.
C    E-FORMAT IS USED WITH THREE SIGNIFICANT DIGITS.
C 
      SUBROUTINE MATPRT (A,N,M)
C 
C    A IS THE MATRIX TO BE PRINTED.
C    N IS THE DIMENSION OF A
C    M IS THE MAXIMUM DIMENSION OF A AS SPECIFIED IN THE CALLING
C    ROUTINE.
C 
      DIMENSION A(M,M)
      WRITE (8,100)
  100 FORMAT (/)
      DO 160 NY=1,100
          NB=NY*65
          IF (NB.GT.N) NB=N
          NSY=(NY-1)*65+1
          DO 140 NX=1,100
              NN=NX*8
              IF (NN.GT.N) NN=N
              NS=(NX-1)*8+1
              WRITE (8,110) (J,J=NS,NN)
  110         FORMAT (6X,14(I6,3X))
              DO 130 I=NSY,NB
                  WRITE (8,120) I,(A(I,J),J=NS,NN)
  120             FORMAT (1X,I3,2X,14E9.3)
  130         CONTINUE
              WRITE (8,100)
              IF (N.LE.NN) GO TO 150
  140     CONTINUE
  150     IF (N.LE.NB) GO TO 170
  160 CONTINUE
  170 RETURN
      END
C    A ROUTINE FOR PRINTING OUT VECTORS
C    SEE DOCUMENTATION ON SUBROUTINE MATPRT
C 
      SUBROUTINE VECPRT (V,N,M)
C 
C    V IS THE VECTOR TO BE PRINTED
C    N IS THE DIMENSION OF THE VECTOR
C    M IS THE MAX DIMENSION FROM CALLING ROUTINE
C 
      DIMENSION V(M)
      WRITE (8,100)
  100 FORMAT (/)
      DO 130 NX=1,100
          NN=NX*8
          IF (NN.GT.N) NN=N
          NS=(NX-1)*8+1
          WRITE (8,110) (J,J=NS,NN)
  110     FORMAT (6X,14(I6,3X))
          WRITE (8,120) (V(J),J=NS,NN)
  120     FORMAT (6X,14E9.3)
          WRITE (8,100)
          IF (N.LE.NN) GO TO 140
  130 CONTINUE
  140 RETURN
      END
C    AN ENCODING ROUTINE TO COMPRESS SEVERAL NODE DESIGNATIONS INTO
C    A SINGLE WORD OF STORAGE.
C 
      SUBROUTINE NCODE (KEEPTH,I,J,K,NWP,NWORD)
C 
C    KEEPTH IS THE NAME OF THE STORAGE ARRAY
C    I IS THE CYCLE DESIGNATION
C    J IS THE POSITION IN THE CYCLE
C    K IS THE DESIGNATION OF THE NODE BEING STORED
C    NWP IS A PARAMETER TO HELP LOCATE THE WORD WHERE THE NODE INDEX
C    WILL BE STORED.
C    NWORD IS 1/2 THE MAXIUM NUMBER OF DECIMAL DIGITS STORED IN A
C    COMPUTER WORD.
C 
      DIMENSION KEEPTH(1)
      NLOC=NWP*(I-1)+((J-1)/NWORD)+1
      NPLACE=J-NWORD*((J-1)/NWORD)-1
      NP=100**NPLACE
      IF (NPLACE.EQ.0) KEEPTH(NLOC)=0
      KEEPTH(NLOC)=KEEPTH(NLOC)+K*NP
      RETURN
      END
C    THIS FUNCTION DECODES THE VALUES STORED BY SUBROUTINE NCODE.
C    CALL STRING VARIABLES ARE THE SAME AS DEFINED IN NCODE.
C 
      FUNCTION NDCODE (KEEPTH,I,J,NWP,NWORD)
      DIMENSION KEEPTH(1)
      NLOC=NWP*(I-1)+((J-1)/NWORD)+1
      NTEMP=KEEPTH(NLOC)
      NPLACE=J-NWORD*((J-1)/NWORD)
      NDCODE=NTEMP/(10**(2*(NPLACE-1)))-100*(NTEMP/10**(2*NPLACE))
      RETURN
      END
